﻿// Programm: myLittleWire.Form1.cs
// Purpose:  Userfriendly Interface for the Little Wire (and compatible) Boards)
// Language: CSharp
// Hardware: Little Wire (and compatible) Boards with ATtiny85 and USB-Interface
// Autor:    R. Hoermann RBS Ulm
// Homepage: arduino.vom-kuhberg.de ->Boards ->LittleWire
// Version:  0.1 2014-03-08

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Threading;                           // for Thread.Sleep()
using littleWireLib;                              // Interface for LittleWire


namespace myLittleWire
{
    public partial class Form1 : Form
    {
        int i_lwvid=0x1781;
        int i_lwpid=0x0C9F;
        littleWire lw;                             // Declare Instanz of Little-Wire-Class

        Graphics g;                                // Declare a global Graphic for Oszi
        Pen p_white   = new Pen(Color.White);      // Declare Pens for Drawing on Graphic
        Pen p_lime    = new Pen(Color.Lime); 
        Pen p_yellow  = new Pen(Color.Yellow);

        public byte[] ab_ow = new byte[8];         // Array of Bytes for One-Wire
        public byte   b_owcnt=0;                   // Counter for One-Wire-Devices

        public Form1()
        {
            InitializeComponent();
            log("Start");
            timer1.Enabled = false;
            timer1.Interval = 1000;
            lw = new littleWire();
            tabControl1.Visible = false;
            this.Text = "LitteWire: ATtiny85 on USB";
        }

        public void log(string s_msg)               // Log a Message with Timestamp to the Listbox
        {
            lib_Log.Items.Insert(0, DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + "  " + s_msg);
        }

        private void btn_Open_Click(object sender, EventArgs e)
        {
            byte b_firmware;
            if (btn_Open.BackColor == Color.Red)
            { timer1.Enabled = false; tabControl1.Visible = false; btn_Open.BackColor = SystemColors.ButtonFace; return; }
            if (lw.isAlive()) 
            { 
                timer1.Enabled = false; tabControl1.Visible = false; btn_Open.BackColor = SystemColors.ButtonFace;
                lbl_Firmware.Text = "";
                lw = new littleWire();
                log("Connection Closed");
                return; 
            }
            try
            {
                lw.connect();
                btn_Open.BackColor = Color.Lime;
                timer1.Enabled = true;
                tabControl1.Visible = true;
                log("Connect Successfull");
                b_firmware = lw.readFirmwareVersion();
                log("Firmware="+b_firmware.ToString("X2"));
                lbl_Firmware.Text = "Firmware =" + b_firmware.ToString("X2") + " VID:PID=" + i_lwvid.ToString("X4") + ":" + i_lwpid.ToString("X4");
            }
            catch
            {   btn_Open.BackColor = Color.Red; log("ERROR"); }
        }

        private void btn_I2C_Scan_Click(object sender, EventArgs e)
        {
            lw.i2c_init();
            lw.i2c_updateDelay(40);
            int i_adr2;
            int i_rc;
            int i_devcnt=0;
            txt_I2C_DevList.Text = "";
            for (byte b_adr= 0; b_adr< 128; b_adr++)
            {
                i_rc = lw.i2c_start(b_adr, littleWire.WRITE); i_adr2 = 2 * b_adr;
                if (i_rc == 0) { txt_I2C_DevList.Text += i_adr2.ToString("X2") + " "; i_devcnt++; }
                if (lw.lwStatus ==false) { log("Connection Lost"); break; }
                Application.DoEvents();
            } 
            if (i_devcnt == 0) { log("NO I2C Devices detected"); }
            if (i_devcnt > 0) { txt_I2C_adr.Text = txt_I2C_DevList.Text.Substring(0, 2); }
            log("I2C Detected Devices="+txt_I2C_DevList.Text);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (lw.lwStatus ==false) { log("Connection lost"); }
        }

        private void btn_Blink_Start_Click(object sender, EventArgs e)
        {
            if (btn_Blink_Start.Text == "Stop") { btn_Blink_Start.Text = "Start"; btn_Blink_Start.BackColor = SystemColors.ButtonFace; return; }
            if (btn_Blink_Start.Text=="Start")
            {
                btn_Blink_Start.Text = "Stop"; btn_Blink_Start.BackColor = Color.Lime;
            lw.pinMode(littleWire.PIN1, littleWire.OUT);
            lw.pinMode(littleWire.PIN2, littleWire.OUT);
            lw.pinMode(littleWire.PIN3, littleWire.OUT);
            lw.pinMode(littleWire.PIN4, littleWire.OUT);
            while(btn_Blink_Start.Text=="Stop")
            {
                log("Blink Hi=" + hsb_Blink_HIGH_ms.Value.ToString() + "ms LO=" + hsb_Blink_LOW_ms.Value.ToString() + "ms");
                if (chb_Blink_pin1.Checked) { lw.digitalWrite(littleWire.PIN1, littleWire.HIGH); }
                if (chb_Blink_pin2.Checked) { lw.digitalWrite(littleWire.PIN2, littleWire.HIGH); }
                if (chb_Blink_pin3.Checked) { lw.digitalWrite(littleWire.PIN3, littleWire.HIGH); }
                if (chb_Blink_pin4.Checked) { lw.digitalWrite(littleWire.PIN4, littleWire.HIGH); }
                Thread.Sleep(hsb_Blink_HIGH_ms.Value); Application.DoEvents();
                if (chb_Blink_pin1.Checked) { lw.digitalWrite(littleWire.PIN1, littleWire.LOW); }
                if (chb_Blink_pin2.Checked) { lw.digitalWrite(littleWire.PIN2, littleWire.LOW); }
                if (chb_Blink_pin3.Checked) { lw.digitalWrite(littleWire.PIN3, littleWire.LOW); }
                if (chb_Blink_pin4.Checked) { lw.digitalWrite(littleWire.PIN4, littleWire.LOW); }
                Thread.Sleep(hsb_Blink_LOW_ms.Value); Application.DoEvents();
                if (lw.lwStatus == false)
                {
                    log("Connection Lost"); btn_Blink_Start.Text = "Start";
                    btn_Blink_Start.BackColor = SystemColors.ButtonFace; return;
                }
            }
          }
        }

        private void btn_LED1_onoff_Click(object sender, EventArgs e)
        {
            lw.pinMode(littleWire.PIN1, littleWire.OUTPUT);
            if (btn_LED1_onoff.Text=="ON")
            { lw.digitalWrite(littleWire.PIN1, 1); btn_LED1_onoff.Text = "OFF"; btn_LED1_onoff.BackColor = Color.Red; }
            else
            { lw.digitalWrite(littleWire.PIN1, 0); btn_LED1_onoff.Text = "ON"; btn_LED1_onoff.BackColor = SystemColors.ButtonFace; }
        }

        private void btn_LED2_onoff_Click(object sender, EventArgs e)
        {
            lw.pinMode(littleWire.PIN2, littleWire.OUTPUT);
            if (btn_LED2_onoff.Text == "ON")
            { lw.digitalWrite(littleWire.PIN2, 1); btn_LED2_onoff.Text = "OFF"; btn_LED2_onoff.BackColor = Color.Lime; }
            else
            { lw.digitalWrite(littleWire.PIN2, 0); btn_LED2_onoff.Text = "ON"; btn_LED2_onoff.BackColor = SystemColors.ButtonFace; }
        }

        private void btn_LED3_onoff_Click(object sender, EventArgs e)
        {
            lw.pinMode(littleWire.PIN3,littleWire.OUTPUT);
            if (btn_LED3_onoff.Text == "ON")
            { lw.digitalWrite(littleWire.PIN3, 1); btn_LED3_onoff.Text = "OFF"; btn_LED3_onoff.BackColor = Color.Blue;}
            else
            { lw.digitalWrite(littleWire.PIN3, 0); btn_LED3_onoff.Text = "ON"; btn_LED3_onoff.BackColor = SystemColors.ButtonFace; }
        }

        private void btn_LED4_onoff_Click(object sender, EventArgs e)
        {
            lw.pinMode(littleWire.PIN4, littleWire.OUTPUT);
            if (btn_LED4_onoff.Text == "ON")
            { lw.digitalWrite(littleWire.PIN4, 1); btn_LED4_onoff.Text = "OFF"; btn_LED4_onoff.BackColor = Color.Yellow; }
            else
            { lw.digitalWrite(littleWire.PIN4, 0); btn_LED4_onoff.Text = "ON"; btn_LED4_onoff.BackColor = SystemColors.ButtonFace; }
        }

        private void btn_I2C_GO_Click(object sender, EventArgs e)
        {
            byte[] ab_i2c_data =new byte[16];
            byte b_datalen=(byte)(txt_I2C_Data.Text.Length/3);
            byte b_datalenx = (byte)(b_datalen + 1);
            try
            {
                byte b_i2cadr=Convert.ToByte(txt_I2C_adr.Text.Substring(0,2),16);
                for (int i = 0; i < b_datalen;i++ )
                {
                    ab_i2c_data[i] = Convert.ToByte(txt_I2C_Data.Text.Substring(i * 3, 2),16);
                }
                lw.i2c_start(b_i2cadr, littleWire.WRITE);
                lw.i2c_write(ab_i2c_data, b_datalenx, littleWire.END_WITH_STOP);
            }
            catch{ MessageBox.Show("ERROR");}
        }

        private void btn_PWM_Start_Click(object sender, EventArgs e)
        {
            if (btn_PWM_Start.Text == "Stop") { btn_PWM_Start.Text = "Start"; btn_PWM_Start.BackColor = SystemColors.ButtonFace; return; }
            if (btn_PWM_Start.Text == "Start")
            {
                btn_PWM_Start.Text = "Stop"; btn_PWM_Start.BackColor = Color.Lime;
                lw.pwm_init();
                while(btn_PWM_Start.Text=="Stop")
                {
                    lw.pwm_updateCompare((byte)hsb_pwm1.Value, (byte)hsb_pwm4.Value);
                    Thread.Sleep(100);
                    if (lw.lwStatus == false) { log("Connection Lost"); break; }
                    Application.DoEvents();
                }
               lw.pwm_stop();
            }
        }

        private void btn_ADC_Start_Click(object sender, EventArgs e)
        {
            int i_adc0, i_adc1;
            int i_adc0mi = +9999; int i_adc1mi = +9999;
            int i_adc0ma = -9999; int i_adc1ma = -9999;
            int i_adc0old=0;
            int i_adc1old=0;
            int i_x = 0;
            int i_y;
            if (btn_ADC_Start.Text == "Stop") { btn_ADC_Start.Text = "Start"; btn_ADC_Start.BackColor = SystemColors.ButtonFace; return; }
            if (btn_ADC_Start.Text == "Start")
            {
                g = pic_Oszi.CreateGraphics();

                btn_ADC_Start.Text = "Stop"; btn_ADC_Start.BackColor = Color.Lime;
                lw.analog_init(littleWire.VREF_1100mV);
                while (btn_ADC_Start.Text == "Stop")
                {
                    if (chb_ADC_Ch0.Checked)
                    { 
                        i_adc0 = lw.analogRead(0);
                        // i_adc0 = 700 + (int)(300 * (Math.Sin(i_x / 2 / 6.28))); // enable for Debugging
                        txt_ADC_Ch0.Text=i_adc0.ToString();
                        log("ADC Ch0=" + i_adc0.ToString()); 
                        if (i_adc0<i_adc0mi){i_adc0mi=i_adc0; lbl_ADC_Ch0_Min.Text="Min="+i_adc0mi.ToString();}
                        if (i_adc0>i_adc0ma){i_adc0ma=i_adc0; lbl_ADC_Ch0_Max.Text="Max="+i_adc0ma.ToString();}
                        i_y=256-i_adc0/4;
                        if (i_x > 0) g.DrawLine(p_lime, i_x - 1, i_adc0old, i_x, i_y);
                        i_adc0old = i_y;
                    }
                    if (chb_ADC_Ch1.Checked) 
                    { 
                        i_adc1 = lw.analogRead(1);
                        // i_adc1 = 300 + (int)(200 * (Math.Sin(i_x / 4 / 6.28)));  // enable for Debugging
                        txt_ADC_Ch1.Text = i_adc1.ToString();
                        log("ADC Ch1=" + i_adc1.ToString()); 
                        if (i_adc1 < i_adc1mi) { i_adc1mi = i_adc1; lbl_ADC_Ch1_Min.Text = "Min=" + i_adc1mi.ToString(); }
                        if (i_adc1 > i_adc1ma) { i_adc1ma = i_adc1; lbl_ADC_Ch1_Max.Text = "Max=" + i_adc1ma.ToString(); }
                        i_y = 256 - i_adc1 / 4;
                        if (i_x > 0) g.DrawLine(p_yellow, i_x - 1, i_adc1old, i_x, i_y);
                        i_adc1old = i_y;
                    }

                    i_x++; if (i_x >= 512) { i_x = 0; g.Clear(Color.Black); }
                    Thread.Sleep(100);
                    Application.DoEvents();
                }
            }
        }

        private void lib_Log_Click(object sender, EventArgs e)
        {
            lib_Log.Items.Clear();
        }

        private void btn_Key_Start_Click(object sender, EventArgs e)
        {
            if (btn_Keys_Start.Text == "Stop") { btn_Keys_Start.Text = "Start"; btn_Keys_Start.BackColor = SystemColors.ButtonFace; return; }
            if (btn_Keys_Start.Text == "Start")
            {
                lw.pinMode(littleWire.PIN1, littleWire.INPUT);
                lw.pinMode(littleWire.PIN2, littleWire.INPUT);
                lw.pinMode(littleWire.PIN3, littleWire.INPUT);
                lw.pinMode(littleWire.PIN4, littleWire.INPUT);
                btn_Keys_Start.Text = "Stop"; btn_Keys_Start.BackColor = Color.Lime;
                while (btn_Keys_Start.Text == "Stop")
                {
                    if (lw.digitalRead(littleWire.PIN1) == littleWire.LOW) { btn_Keys_Start.Left += 10; }
                    if (lw.digitalRead(littleWire.PIN3) == littleWire.LOW) { btn_Keys_Start.Left -= 10; }
                    if (lw.digitalRead(littleWire.PIN2) == littleWire.LOW) { btn_Keys_Start.Top  -= 10; }
                    if (lw.digitalRead(littleWire.PIN4) == littleWire.LOW) { btn_Keys_Start.Top  += 10; }
                    Thread.Sleep(100);
                    Application.DoEvents();
                }
            }
        }

        private void btn_OneWire_Start_Click(object sender, EventArgs e)
        {
            byte b;
            byte b_scratch;
            int  i_templo=0;
            int  i_temphi = 0;
            float f_tempnk=0;
            float f_tempcel = 0;

            if (btn_OneWire_Start.Text == "Stop") { btn_OneWire_Start.Text = "Start"; btn_OneWire_Start.BackColor = SystemColors.ButtonFace; return; }
            if (b_owcnt == 0) { log("NO One Wire Devices registiered"); return; }
            if (btn_OneWire_Start.Text == "Start")
            {
                btn_OneWire_Start.Text = "Stop"; btn_OneWire_Start.BackColor = Color.Lime;
                while (btn_OneWire_Start.Text == "Stop")
                {
                    if (lw.onewire_resetPulse()==0)
                    {
                        log("NO more One-Wire Device");
                        btn_OneWire_Start.Text = "Start";
                        btn_OneWire_Start.BackColor = SystemColors.ButtonFace; 
                    }
                    lw.onewire_writeByte(0x55); // MATCH ROM
                    for (b = 0; b <= 7; b++) { lw.onewire_writeByte(ab_ow[b]); }
                    lw.onewire_writeByte(0x44);
                    Thread.Sleep(650);
                    if (lw.onewire_resetPulse() == 0)
                    {
                        log("NO more One-Wire Device");
                        btn_OneWire_Start.Text = "Start";
                        btn_OneWire_Start.BackColor = SystemColors.ButtonFace;
                    }
                    lw.onewire_writeByte(0x55); // MATCH ROM
                    for (b = 0; b <= 7; b++) { lw.onewire_writeByte(ab_ow[b]); }
                    lw.onewire_writeByte(0xBE);

                    for (b = 0; b < 9; b++)
                    {
                        b_scratch = lw.onewire_readByte();
                        if (b == 0) { i_templo = b_scratch; }
                        if (b == 1) { i_temphi = b_scratch; }
                    }
                    if ((i_templo & 0x01) == 0x01) { f_tempnk =  625; }
                    if ((i_templo & 0x02) == 0x02) { f_tempnk+= 1250; }
                    if ((i_templo & 0x04) == 0x04) { f_tempnk+= 2500; }
                    if ((i_templo & 0x08) == 0x08) { f_tempnk+= 5000; }
                    f_tempnk /= 10000;
                    f_tempcel = (((i_templo & 0x00F0) >> 4) | ((i_temphi & 0x0007) << 4))+f_tempnk;
                    log("Temperatur=" + f_tempcel.ToString("F3")+ " °C");
                    Thread.Sleep(100);
                    Application.DoEvents();
                }
            }
        }

        private void btn_OneWire_Scan_Click(object sender, EventArgs e)
        {
            b_owcnt = 0;
            string s_owadr="";
            if (lw.onewire_firstAddress(ab_ow)>0)
            {
                for (int i = 0; i < 7; i++) { s_owadr += ab_ow[i].ToString("X2") + " "; }
                log("1. One Wire Adr=" + s_owadr);
                b_owcnt++;
            }
            while (lw.onewire_nextAddress(ab_ow) > 0)
            {
                for (int i = 0; i < 7; i++) { s_owadr += ab_ow[i].ToString("X2") + " "; }
                b_owcnt++;
                log(b_owcnt.ToString()+". One Wire Adr=" + s_owadr);
            }
            log(b_owcnt.ToString() + " One Wire Devices detected");
        }

       
    }
}
