﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO.Ports;  // wegen GetPortNames();
using System.Media;     // wegen Systemsound.Beep.Play();
using System.IO;        // wegen Filemode usw

namespace Stereo_DAC_PORT_DLL
{
    public partial class Form1 : Form
    {
        Cla_SPI spi = new Cla_SPI();
        System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();

        int[] ai_sin2 = new int[180];
        int[] ai_sin4 = new int[180];
        int[] ai_sin6 = new int[180];
        byte[] ab_wav;
        int wav_channels = -1;
        int wav_bitDepth = -1;
        int wav_fileSize = -1;
        int wav_fmtAvgBPS = -1;
        int wav_values = -1;
        double wav_playtime = -1.0;

        string[] as_RBS_ULM ={"RRRR    BBBB     SSSS      U    U  L     M   M",
                              "R   R   B   B   S          U    U  L     MM MM",
                              "RRRR    BBBB     SSS       U    U  L     M M M",
                              "R  R    B   B       S      U    U  L     M   M",
                              "R   R   BBBB    SSSS        UUUU   LLLLL M   M"};

        string[] as_Spatz   ={"       #                  ",
                              "      # #                 ",
                              "     ##  #        #       ",
                              "     #     #     #####    ",
                              "     #      #   ##    #   ",      
                              "     #      ##  #   #  # #",
                              "     #       ###       # #",
                              "     ##               ####",
                              "      #             ### ##",
                              "      ##           #    ##",
                              "       ##          #    # ",
                              "        #         #       ",
                              "        #        ##       ",
                              "       #         #        ",
                              "      #         #         ",
                              "     #         #          ",
                              "   ##  ########           ",
                              "  ##  #                   ",
                              "##   #                    ",
                              "  # #                     ",
                              "  ##                      "};
                              
                              
        Graphics g;
        Pen p_Lime    = new Pen(Color.Lime);
        Pen p_Yellow  = new Pen(Color.Yellow);
        Pen p_Magenta = new Pen(Color.Magenta);
        bool b_stop = false;
        int i_cnt = 0;
        string s_title = "Stereo DAC via SPI an COMx mit PORT.DLL (fast)";


        public int ggy(int x, int dep)
        {
            if (dep == 8) { return ab_wav[x]; }
            int ylow = ab_wav[2 * x];
            int yhigh = ab_wav[2 * x + 1];
            if (yhigh < 128) { return 256 * yhigh + ylow; } else { return 256 * yhigh + ylow - 65536; }
        }
      
        public Form1()
        {
            InitializeComponent();
            string[] ports = SerialPort.GetPortNames();
            foreach (string spn in ports) { cob_ComSel.Items.Add(spn); } cob_ComSel.SelectedIndex = 0;
           
            this.Text = s_title;
            timer1.Interval = 100;
            timer1.Enabled = true;
            panel1.Visible = false;
            hsb_Right.Maximum = 1023;
            hsb_Left.Maximum  = 1023;
            double rad = Math.PI / 180.0;
            btn_Stop.Visible = false;
            btn_Stop.BackColor = Color.Red;
            pic_Graf.BackColor = Color.Black;
            g = pic_Graf.CreateGraphics();
            for (int x = 0; x < 180; x++)
            {
                ai_sin2[x] = (int)(511.0 + 511.0 * Math.Sin(2 * x * rad));
                ai_sin4[x] = (int)(511.0 + 511.0 * Math.Sin(4 * x * rad));
                ai_sin6[x] = (int)(511.0 + 511.0 * Math.Sin(8 * x * rad));
            }
            openFileDialog1.Filter = "Wav files (*.wav)|*.wav";
            openFileDialog1.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.MyMusic);
        }

        private void btn_Open_Click(object sender, EventArgs e)
        {
            panel1.Visible = false; btn_Open.Text = "Open";
            cob_ComSel.Visible = true;
            if (btn_Open.BackColor == Color.Red)  { btn_Open.BackColor = SystemColors.ButtonFace; return; }
            if (btn_Open.BackColor == Color.Lime) { btn_Open.BackColor = SystemColors.ButtonFace; b_stop = true; i_cnt = 0; spi.Close(); return; }
            string s_pn = cob_ComSel.Items[cob_ComSel.SelectedIndex].ToString();
            try
            {
                spi.Open(s_pn, 115200, 'n', 8, 1);
                btn_Open.Text=s_pn;
                btn_Open.BackColor = Color.Lime;
                cob_ComSel.Visible = false;
                panel1.Visible = true;
            }
            catch { btn_Open.BackColor = Color.Red; }

        }
        private void btn_RST_High_Click(object sender, EventArgs e)       { spi.RSTi(true);  }
        private void btn_RST_Low_Click(object sender, EventArgs e)        { spi.RSTi(false); }
        private void btn_MOSI_High_Click(object sender, EventArgs e)      { spi.MOSI(true);  }
        private void btn_MOSI_Low_Click(object sender, EventArgs e)       { spi.MOSI(false); }
        private void btn_SCK_High_Click(object sender, EventArgs e)       { spi.SCK(true);   }
        private void btn_SCK_Low_Click(object sender, EventArgs e)        { spi.SCK(false);  }

        private void btn_Interface_Click(object sender, EventArgs e)
        {
            Form_Interface f_interface = new Form_Interface();
            f_interface.Show();
        }

        private void hsb_Left_ValueChanged(object sender, EventArgs e)
        {
            g.Clear(Color.Black); g.DrawLine(p_Yellow, hsb_Left.Value / 4, 0, hsb_Left.Value / 4, 255); g.DrawLine(p_Lime, 0, 256-hsb_Right.Value / 4, 255,256- hsb_Right.Value / 4);
            spi.set_DA_L(hsb_Left.Value);
        }

        private void hsb_Right_ValueChanged(object sender, EventArgs e)
        {
            g.Clear(Color.Black); g.DrawLine(p_Yellow, hsb_Left.Value / 4, 0, hsb_Left.Value/4, 255); g.DrawLine(p_Lime, 0,256- hsb_Right.Value/4, 255,256- hsb_Right.Value / 4);
            spi.set_DA_R(hsb_Right.Value);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (!spi.isOpen()) { lbl_DCD.Text = "DCD is undef"; lbl_DSR.Text = "DSR is undef"; lbl_CTS.Text = "CTS is undef"; return; }
            if (spi.MOSIin()) { lbl_DCD.Text = "DCD/MOSI is HIGH"; } else { lbl_DCD.Text = "DCD/MOSI is LOW"; }
            if (spi.SCKin()) { lbl_DSR.Text = "DSR/SCK is HIGH"; } else { lbl_DSR.Text = "DSR/SCK is LOW"; }
            if (spi.RSTiin()) { lbl_CTS.Text = "CTS/RSTi is HIGH"; } else { lbl_CTS.Text = "CTS/RSTi is LOW"; }
        }

       
        private void Stop_Message(string s_msg)
        {
            btn_Stop.Visible = false; b_stop = false;
            sw.Stop(); SystemSounds.Beep.Play();
            MessageBox.Show(i_cnt.ToString() + s_msg + " in " + sw.ElapsedMilliseconds.ToString() + " ms");
            i_cnt = 0;
        }

        private void btn_Quadrat_Click(object sender, EventArgs e)
        {
            g.Clear(Color.Black);
            for (int y = 100; y < 1001; y += 20) { g.DrawLine(p_Yellow, y / 4, 25, y / 4, 26); }
            for (int y = 1000; y >= 100; y -= 50) { g.DrawLine(p_Yellow,250,y/4,251,y/4); }
            for (int y = 1000; y >= 100; y -= 20) { g.DrawLine(p_Yellow,y/4,250,y/4,251); }
            for (int y = 100;  y < 1001; y += 50) { g.DrawLine(p_Yellow,25,y/4,26,y/4); }
            sw.Reset(); sw.Start();
            btn_Stop.Visible = true; btn_Stop.Focus(); Application.DoEvents();
            while (!b_stop)
            {
                for (int y =  100; y < 1001; y += 20) { spi.set_DA_L(y); }
                for (int y = 1000; y >= 100; y -= 50) { spi.set_DA_R(y); }
                for (int y = 1000; y >= 100; y -= 20) { spi.set_DA_L(y); }
                for (int y =  100; y < 1001; y += 50) { spi.set_DA_R(y); }
                i_cnt++;
                Application.DoEvents();
            }
            Stop_Message(" Quadrate");
        }

        private void btn_Stop_Click(object sender, EventArgs e)
        {
             b_stop = true; 
        }

        private void btn_Lissajou_Click(object sender, EventArgs e)
        {
            int i_i;
            g.Clear(Color.Black);
            for (int i = 0; i < 180; i++)
            {
               g.DrawLine(p_Yellow,ai_sin4[i]/4,ai_sin6[i]/4,1+ai_sin4[i]/4,1+ai_sin6[i]/4);
            }
            sw.Reset(); sw.Start();
            btn_Stop.Visible = true; btn_Stop.Focus(); Application.DoEvents();
            while (!b_stop)
            {
                for (int i = 0; i < 1800; i++)
                {
                    i_i = i % 180;
                    spi.set_DA_L(ai_sin4[i_i]); spi.set_DA_R(ai_sin6[i_i]);
                }
                i_cnt++;
                Application.DoEvents();
            }
            Stop_Message(" Lissajou");
        }

        private void btn_Sinus_Click(object sender, EventArgs e)
        {
            g.Clear(Color.Black);
            for (int x = 0; x < 180; x++)
            {
                g.DrawLine(p_Lime, 2 * x, 256-ai_sin2[x] / 4, 2 * x + 1, 256-ai_sin2[x] / 4);
                g.DrawLine(p_Yellow, 2 * x,256- ai_sin4[x] / 4, 2 * x + 1,256-ai_sin4[x] / 4);
                g.DrawLine(p_Magenta, 2 * x,256- ai_sin6[x] / 4, 2 * x + 1,256- ai_sin6[x] / 4);
            }
            sw.Reset(); sw.Start();
            btn_Stop.Visible = true; btn_Stop.Focus(); Application.DoEvents();
            while (!b_stop)
            {
                for (int x = 0; x < 1800; x++) { spi.set_DA_R(ai_sin2[x % 180]); spi.set_DA_L(x/2); }
                i_cnt++; Application.DoEvents();
            }
            Stop_Message(" 100*Sinus");
        }

        private void btn_RbsUlm_Click(object sender, EventArgs e)
        {
            int i_sl = as_RBS_ULM[0].Length;
            g.Clear(Color.Black);
            for (int y = 0; y < 5; y++)
            {
                int g_y=10+5*y;
                for (int x = 0; x < i_sl; x++)
                { if (as_RBS_ULM[y].Substring(x, 1) != " ") { g.DrawLine(p_Yellow,10+5 * x,g_y,11+5*x,g_y+1); } }
            }
            sw.Reset(); sw.Start();
            btn_Stop.Visible = true; btn_Stop.Focus(); Application.DoEvents();
           
            while (!b_stop)
            {
                for (int y = 0; y < 5; y++)
                {
                    spi.set_DA_R(700 - 100 * y);
                    for (int x = 0; x < i_sl; x++)
                    { if (as_RBS_ULM[y].Substring(x, 1) != " ") {  spi.set_DA_L(15 * x); } }
                }
                i_cnt++; Application.DoEvents();
            }
            Stop_Message(" RBS-ULM");
        }

        private void btn_Spatz_Click(object sender, EventArgs e)
        {
            int i_sl = as_Spatz[0].Length;
            g.Clear(Color.Black);
            for (int y = 0; y < 21; y++)
            {
                int g_y = 10 + 3 * y;
                for (int x = 0; x < i_sl; x++)
                { if (as_Spatz[y].Substring(x, 1) != " ") { g.DrawLine(p_Yellow, 10 + 5 * x, g_y, 11 + 5 * x, g_y + 1); } }
            }
            sw.Reset(); sw.Start();
            btn_Stop.Visible = true; btn_Stop.Focus(); Application.DoEvents();

            while (!b_stop)
            {
                for (int y = 0; y < 21; y++)
                {
                    spi.set_DA_R(700 - 20 * y);
                    for (int x = 0; x < i_sl; x++)
                    { if (as_Spatz[y].Substring(x, 1) != " ") { spi.set_DA_L(20 * x); } }
                }
                i_cnt++; Application.DoEvents();
            }
            Stop_Message(" Spatz");

        }

        private void btn_Saegezahn_Click(object sender, EventArgs e)
        {
            g.Clear(Color.Black);
            for (int i = 0; i < 360; i++) {g.DrawLine(p_Yellow,i-1,i,i,i); }
            sw.Reset(); sw.Start();
            btn_Stop.Visible = true; btn_Stop.Focus(); Application.DoEvents();
            while (!b_stop)
            {
                for (int i = 0; i < 1024; i+=32){ spi.set_DA_L(i); }
                for (int i = 1020; i>0; i -= 32) { spi.set_DA_L(i); } 
                i_cnt++; Application.DoEvents();
            }
            Stop_Message(" Sägezahn");

        }

        private void btn_MaxSCK_Click(object sender, EventArgs e)
        {
            sw.Reset(); sw.Start();
            for (int i = 0; i < 10000; i++) { spi.SCK(true); spi.SCK(false); }
            sw.Stop();
            double fmax = 10000.0 / sw.ElapsedMilliseconds;
            MessageBox.Show("SCK fmax="+ fmax.ToString("F2") + " kHz");
        }

        private void btn_LoadWav_Click(object sender, EventArgs e)
        {
            int y, yold, ymax, ymin;
            string s_Error = "";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                
                FileStream fs_wav = new FileStream(openFileDialog1.FileName, FileMode.Open, FileAccess.Read);
                BinaryReader br = new BinaryReader(fs_wav);

                int wav_chunkID = br.ReadInt32(); 
                wav_fileSize = br.ReadInt32(); lbl_WavInfo.Text=openFileDialog1.FileName+" FileSize=" + wav_fileSize.ToString();
                int wav_riffType = br.ReadInt32(); 
                int wav_fmtID = br.ReadInt32(); 
                int wav_fmtSize = br.ReadInt32(); 
                int wav_fmtCode = br.ReadInt16(); 
                wav_channels = br.ReadInt16(); lbl_WavInfo.Text+=" Channels=" + wav_channels.ToString();
                int wav_sampleRate = br.ReadInt32(); 
                wav_fmtAvgBPS = br.ReadInt32(); lbl_WavInfo.Text+="\n AvgBPS=" + wav_fmtAvgBPS.ToString();
                int wav_fmtBlockAlign = br.ReadInt16(); 
                wav_bitDepth = br.ReadInt16(); lbl_WavInfo.Text+=" Bits=" + wav_bitDepth.ToString();
                if (wav_fmtSize == 18) // Read any extra values
                {
                    int wav_fmtExtraSize = br.ReadInt16(); 
                    br.ReadBytes(wav_fmtExtraSize);
                }
                int wav_dataID = br.ReadInt32();
                int wav_dataSize = br.ReadInt32(); wav_values = wav_dataSize; if (wav_channels == 2) { wav_values = wav_values / 2; }
                if (wav_bitDepth == 16) { wav_values = wav_values / 2; }
                wav_playtime = wav_values / wav_fmtAvgBPS;
                lbl_WavInfo.Text+=" Vals="+wav_values.ToString()+" Playtime=" + wav_playtime.ToString("F3") + " sec";
                if (wav_chunkID != 1179011410) { s_Error += " fehlerhafte ID not RIFF"; }
                if (wav_riffType != 1163280727) { s_Error += " fehlerhafte type not WAVE"; }
                if (wav_fmtID != 544501094) { s_Error += " fehlerhafte ID not fmt"; }
                if (wav_dataID != 1635017060) { s_Error += "  fehlerhafte ID not data"; }
                if (s_Error != "") { MessageBox.Show(s_Error); }
                ab_wav = br.ReadBytes(wav_dataSize);

                ymax = -99999; ymin = 99999;
                for (int x = 1; x < 640; x++)
                {
                    y = ggy(x, wav_bitDepth);
                    // lib_Left.Items.Add(y.ToString());
                    if (y > ymax) { ymax = y; }
                    if (y < ymin) { ymin = y; }
                    if (wav_channels == 2)
                    {
                        y = ggy(x, wav_bitDepth);
                       // lib_Right.Items.Add(y.ToString());
                        if (y > ymax) { ymax = y; }
                        if (y < ymin) { ymin = y; }
                    }
                }
                try
                {
                    yold = ggy(0, wav_bitDepth);
                    if (wav_channels == 1) // MONO
                    {
                        /*
                        pic_ChLeft.Visible = true; pic_ChRight.Visible = false; g_ChLeft.Clear(Color.Black);
                        for (int x = 1; x < 640; x++)
                        {
                            y = ggy(x, wav_bitDepth);
                            lib_Left.Items.Add(y.ToString());
                            if (y > ymax) { ymax = y; }
                            if (y < ymin) { ymin = y; }
                            if (wav_bitDepth == 16) { y = 128 + y / 10; }
                            xx = x % 640; g_ChLeft.DrawLine(p_ChLeft, xx - 1, yold, xx, y); yold = y;
                        }
                      */
                    }
                }
                catch { }
                if (wav_channels == 2) // STEREO
                    // { pic_ChLeft.Visible = true; pic_ChRight.Visible = true; g_ChLeft.Clear(Color.Black); g_ChRight.Clear(Color.Black); }
                    MessageBox.Show("Max=" + ymax.ToString() + " Min=" + ymin.ToString());
            }


        }

        private void btn_WAV_Click(object sender, EventArgs e)
        {
            if (wav_channels < 0) { MessageBox.Show("No Wave loaded"); return; }
            int[] ai_left = new int[4096];
            int[] ai_right = new int[4096];
            int y=0;
            int yold=y;
            int i_vals = Math.Min(4096, wav_values);
            int ymax=-99999, ymin=99999;
            if (wav_channels == 1) // MONO
            {
                g.Clear(Color.Black);
                y = ggy(0, wav_bitDepth); yold = y;
                for (int i = 1; i < i_vals;i++)
                {
                    y = ggy(i, wav_bitDepth);
                    if (y > ymax) { ymax = y; }
                    if (y < ymin) { ymin = y; }
                    if (wav_bitDepth == 16) { y = 128 + y / 10; }
                    if (i < 360) { g.DrawLine(p_Yellow, i - 1,255-yold, i, 255-y); yold = y; }
                    ai_left[i] = 4*y;
                }

                sw.Reset(); sw.Start();
                btn_Stop.Visible = true; btn_Stop.Focus(); Application.DoEvents();
                while (!b_stop & (i_cnt<100))
                {
                    for (int i = 0; i < i_vals; i++){spi.set_DA_L(ai_left[i]);}
                    i_cnt++; Application.DoEvents();
                }
                Stop_Message(" WAV ");
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (i_cnt != 0) { MessageBox.Show("Stop DAC first"); e.Cancel = true; return; }
            if (spi.isOpen()) { MessageBox.Show("Close COM fisrst"); e.Cancel = true; }
        }

      
    }
}
