﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO.Ports;

namespace Stereo_DAC_10Bit_with_MCP4912
{
    public partial class Form1 : Form
    {
        int[] ai_sin2 = new int[180];
        int[] ai_sin3 = new int[180];
        byte[] ab_rst = { (byte)5 };
        string s_title = "Stereo DAC 10 Bit mit MCP 4912";
        System.Diagnostics.Stopwatch s = new System.Diagnostics.Stopwatch();

        public Form1()
        {
            InitializeComponent();
            string[] ports = SerialPort.GetPortNames();
            foreach (string spn in ports) { cob_ComSel.Items.Add(spn); }
            cob_ComSel.SelectedIndex = cob_ComSel.Items.Count - 1;
        
            this.Text = s_title;      
            serialPort1.BaudRate = 115200;
            serialPort1.DataBits = 5;
            serialPort1.Parity = System.IO.Ports.Parity.None;
            //   serialPort1.StopBits = System.IO.Ports.StopBits.None;
            panel1.Visible = false; panel1.BackColor = Color.DarkGray;
            hsb_Left.Maximum = 1023;
            hsb_Right.Maximum = 1023;
            double rad = Math.PI / 180.0;
            for (int x = 0; x < 180; x++)
            {
                ai_sin2[x] = (int)(511.0 + 511.0 * Math.Sin(4 * x * rad));
                ai_sin3[x] = (int)(511.0 + 511.0 * Math.Sin(6 * x * rad));
            }
        }

        private void btn_Open_Click(object sender, EventArgs e)
        {
            if (serialPort1.IsOpen)
            {
                serialPort1.Close(); panel1.Visible = false; btn_Open.BackColor = SystemColors.ButtonFace; btn_Open.Text = "Open"; cob_ComSel.Visible=true; return;
            }
            if (btn_Open.BackColor == Color.Red) { btn_Open.BackColor = SystemColors.ButtonFace; return; }
            try
            {
                cob_ComSel.Visible=false;
                serialPort1.PortName=cob_ComSel.Items[cob_ComSel.SelectedIndex].ToString();
                btn_Open.Text = serialPort1.PortName;
                serialPort1.Open();
                panel1.Visible = true;
                btn_Open.BackColor = Color.Lime;
            }
            catch { btn_Open.BackColor = Color.Red; }

        }
   
        private void set_DA(byte b_cha, int i_val)
        {
            int i_defcfg = 0x3000;
            int i_cnt, i_sdi, i_bit;
            double d_spg;

            if (b_cha > 1) { MessageBox.Show("Falscher Kanal: " + b_cha.ToString()); return; }
            if (i_val > 1023) { MessageBox.Show("DA-Value to big " + i_val.ToString()); return; }
            d_spg = i_val / 1023.0 * 5.0;
            if (b_cha == 0) { txt_Left.Text = d_spg.ToString("F3") + " V"; }
            if (b_cha == 1) { txt_Right.Text = d_spg.ToString("F3") + " V"; }
            i_sdi = (b_cha << 15) | i_defcfg | (i_val << 2);
            for (i_cnt = 15; i_cnt >= 0; i_cnt--)  // Shift out the 16 bits MSB to LSB
            {
                i_bit = (i_sdi >> i_cnt) & 0x1;
                if (i_bit == 1) { serialPort1.DtrEnable = true; } else { serialPort1.DtrEnable = false; }

                serialPort1.RtsEnable = true;
                serialPort1.RtsEnable = false;
            }
            serialPort1.Write(ab_rst, 0, 1);
        }

        private void set_DA_L_fast(int i_val)
        {
            serialPort1.DtrEnable = false; serialPort1.RtsEnable = true; serialPort1.RtsEnable = false; // 15=Channel=0
            serialPort1.DtrEnable = false; serialPort1.RtsEnable = true; serialPort1.RtsEnable = false; // 14=Buffer=0
            serialPort1.DtrEnable = true;  serialPort1.RtsEnable = true; serialPort1.RtsEnable = false; // 13=/GAIN=1=1x
            serialPort1.DtrEnable = true;  serialPort1.RtsEnable = true; serialPort1.RtsEnable = false; // 12=/SHDN=1=active

            serialPort1.DtrEnable = ((i_val & 0x200) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x100) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x080) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x040) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x020) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x010) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x008) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x004) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x002) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x001) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.Write(ab_rst, 0, 1);
        }

        private void set_DA_R_fast(int i_val)
        {
            serialPort1.DtrEnable = true;  serialPort1.RtsEnable = true; serialPort1.RtsEnable = false; // 15=channel=1
            serialPort1.DtrEnable = false; serialPort1.RtsEnable = true; serialPort1.RtsEnable = false; // 14=Buffer =0
            serialPort1.DtrEnable = true;  serialPort1.RtsEnable = true; serialPort1.RtsEnable = false; // 13=/GAIN=1=1x
            serialPort1.DtrEnable = true;  serialPort1.RtsEnable = true; serialPort1.RtsEnable = false; // 12=/SHDN=1=active

            serialPort1.DtrEnable = ((i_val & 0x200) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x100) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x080) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x040) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x020) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x010) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x008) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x004) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x002) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.DtrEnable = ((i_val & 0x001) > 0); serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.RtsEnable = true; serialPort1.RtsEnable = false;
            serialPort1.Write(ab_rst, 0, 1);
        }

        private void hsb_Left_ValueChanged(object sender, EventArgs e)
        {
            set_DA(0, hsb_Left.Value);
        }

        private void hsb_Right_ValueChanged(object sender, EventArgs e)
        {
            set_DA(1, hsb_Right.Value);
        }

        private void btn_Lissajou_Click(object sender, EventArgs e)
        {
            int i_i;
            s.Reset(); s.Start();
            for (int i = 0; i < 1800; i++)
            {
                i_i = i % 180;
                set_DA_L_fast(ai_sin2[i_i]); set_DA_R_fast(ai_sin3[i_i]);
            }
            s.Stop();
            Console.Beep();
            MessageBox.Show("10 Lissajou in " + s.ElapsedMilliseconds.ToString() + "ms");
        }

        private void btn_Quadrat_Click(object sender, EventArgs e)
        {
            s.Reset(); s.Start();
            for (int i = 0; i < 100; i++)
            {
                for (int y =  100; y < 1001; y += 100) { set_DA_L_fast(y); }
                for (int y = 1000; y >= 100; y -= 100) { set_DA_R_fast(y); }
                for (int y = 1000; y >= 100; y -= 100) { set_DA_L_fast(y); }
                for (int y =  100; y < 1001; y += 100) { set_DA_R_fast(y); }
            }
            s.Stop();
            Console.Beep();
            MessageBox.Show("100 Quadrate in "+s.ElapsedMilliseconds.ToString()+"ms");
        }

        private void btn_Interface_Click(object sender, EventArgs e)
        {
            Form2 f_interface = new Form2(); 
            f_interface.Show(); 
        }


    }
}
